/*
 * Decompiled with CFR 0.152.
 */
package panther.util.general;

import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import panther.util.general.DevOut;
import panther.util.general.XMLUtils;
import pse.util.general.FileUtils;

public class TraceXML {
    public static void main(String[] stringArray) throws Exception {
        DevOut.println(TraceXML.trace(FileUtils.readFile(stringArray[0]).toString()));
    }

    public static String trace(String string) throws Exception {
        return TraceXML.trace(XMLUtils.parseToNode(string));
    }

    public static String trace(Node node) {
        StringBuffer stringBuffer = new StringBuffer();
        node.normalize();
        TraceXML.trace(node, stringBuffer, "", "  ");
        return stringBuffer.toString();
    }

    public static void trace(Node node, StringBuffer stringBuffer, String string, String string2) {
        if (node == null) {
            return;
        }
        stringBuffer.append(string);
        stringBuffer.append("======================\n");
        if (node instanceof Attr) {
            TraceXML.trace((Attr)node, stringBuffer, string, string2);
        } else if (node instanceof CDATASection) {
            TraceXML.trace((CDATASection)node, stringBuffer, string, string2);
        } else if (node instanceof Comment) {
            TraceXML.trace((Comment)node, stringBuffer, string, string2);
        } else if (node instanceof Document) {
            TraceXML.trace((Document)node, stringBuffer, string, string2);
        } else if (node instanceof DocumentFragment) {
            TraceXML.trace((DocumentFragment)node, stringBuffer, string, string2);
        } else if (node instanceof DocumentType) {
            TraceXML.trace((DocumentType)node, stringBuffer, string, string2);
        } else if (node instanceof Element) {
            TraceXML.trace((Element)node, stringBuffer, string, string2);
        } else if (node instanceof Entity) {
            TraceXML.trace((Entity)node, stringBuffer, string, string2);
        } else if (node instanceof EntityReference) {
            TraceXML.trace((EntityReference)node, stringBuffer, string, string2);
        } else if (node instanceof Notation) {
            TraceXML.trace((Notation)node, stringBuffer, string, string2);
        } else if (node instanceof ProcessingInstruction) {
            TraceXML.trace((ProcessingInstruction)node, stringBuffer, string, string2);
        } else if (node instanceof Text) {
            TraceXML.trace((Text)node, stringBuffer, string, string2);
        } else {
            throw new Error("Unrecognized node: " + node);
        }
        stringBuffer.append(string);
        stringBuffer.append("======================\n\n");
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                TraceXML.trace(namedNodeMap.item(i), stringBuffer, string + string2, string2);
            }
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            TraceXML.trace(nodeList.item(i), stringBuffer, string + string2, string2);
        }
    }

    public static void trace(Attr attr, StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append(string);
        stringBuffer.append("Attr\n");
        TraceXML.dumpNode(attr, stringBuffer, string, string2);
        stringBuffer.append(string);
        stringBuffer.append("name: ");
        stringBuffer.append(attr.getName());
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("specified: ");
        stringBuffer.append(attr.getSpecified());
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("value: ");
        stringBuffer.append(attr.getValue());
        stringBuffer.append("\n");
    }

    public static void trace(CDATASection cDATASection, StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append(string);
        stringBuffer.append("CDATASection\n");
        TraceXML.dumpNode(cDATASection, stringBuffer, string, string2);
    }

    public static void trace(Comment comment, StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append(string);
        stringBuffer.append("Comment\n");
        TraceXML.dumpNode(comment, stringBuffer, string, string2);
    }

    public static void trace(Document document, StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append(string);
        stringBuffer.append("Document\n");
        TraceXML.dumpNode(document, stringBuffer, string, string2);
    }

    public static void trace(DocumentFragment documentFragment, StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append(string);
        stringBuffer.append("DocumentFragment\n");
        TraceXML.dumpNode(documentFragment, stringBuffer, string, string2);
    }

    public static void trace(DocumentType documentType, StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append(string);
        stringBuffer.append("DocumentType\n");
        TraceXML.dumpNode(documentType, stringBuffer, string, string2);
    }

    public static void trace(Element element, StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append(string);
        stringBuffer.append("Element\n");
        TraceXML.dumpNode(element, stringBuffer, string, string2);
        stringBuffer.append(string);
        stringBuffer.append("tagName: ");
        stringBuffer.append(element.getTagName());
        stringBuffer.append("\n");
    }

    public static void trace(Entity entity, StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append(string);
        stringBuffer.append("Entity\n");
        TraceXML.dumpNode(entity, stringBuffer, string, string2);
    }

    public static void trace(EntityReference entityReference, StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append(string);
        stringBuffer.append("EntityReference\n");
        TraceXML.dumpNode(entityReference, stringBuffer, string, string2);
    }

    public static void trace(Notation notation, StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append(string);
        stringBuffer.append("Notation\n");
        TraceXML.dumpNode(notation, stringBuffer, string, string2);
    }

    public static void trace(ProcessingInstruction processingInstruction, StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append(string);
        stringBuffer.append("ProcessingInstruction\n");
        TraceXML.dumpNode(processingInstruction, stringBuffer, string, string2);
    }

    public static void trace(Text text, StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append(string);
        stringBuffer.append("Text\n");
        TraceXML.dumpNode(text, stringBuffer, string, string2);
        stringBuffer.append(string);
        stringBuffer.append("length: ");
        stringBuffer.append(text.getLength());
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("data: ");
        stringBuffer.append(text.getData());
        stringBuffer.append("\n");
    }

    protected static void dumpNode(Node node, StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append(string);
        stringBuffer.append("localName: ");
        stringBuffer.append(node.getLocalName());
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("namespaceURI: ");
        stringBuffer.append(node.getNamespaceURI());
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("nodeName: ");
        stringBuffer.append(node.getNodeName());
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("nodeType: ");
        stringBuffer.append(node.getNodeType());
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("nodeValue: ");
        stringBuffer.append(node.getNodeValue());
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("prefix: ");
        stringBuffer.append(node.getPrefix());
        stringBuffer.append("\n");
    }
}

